// serversat v3

#declare sp = 0.30 ;

#declare xbeam = cylinder { 0, sp*x, 0.03*sp
                 texture { pigment { color rgbt < 1.0, 1.0, 0.0, 0.998 > }
                           finish  { ambient 70.0 diffuse 0.0 }
                         }
}

#declare ybeam = object { xbeam rotate  90*z }

#declare zbeam = object { xbeam rotate -90*y }

#declare thruster = disc { 0, z, 0.02
            texture { pigment { White } finish { ambient 1.0 diffuse 0.0 } }
}

#declare solar    = box {
            < -0.008, -0.015, -0.001 >, <0.008, 0.015, 0.001 >
            texture { pigment { Gray } finish { ambient 1.0 diffuse 0.0 } }
}

#declare solarh   = box {
            < -0.008,  0.005, -0.001 >, <0.008, 0.015, 0.001 >
            texture { pigment { Gray } finish { ambient 1.0 diffuse 0.0 } }
}

#declare  radio   = box {
            < -0.003, -0.003, -0.002 >, <0.003, 0.003, 0.002 >
            texture { pigment { White } finish { ambient 1.0 diffuse 0.0 } }
            rotate 45*z 
            translate 0.02*y 
}

#declare  sr  = union { object { solar  } object { radio } }
#declare  shr = union { object { solarh } object { radio } }

#declare ss1 = union {
   object { thruster translate <  0.000,  0.080,  0.000 > }
   object { thruster translate < -0.054, -0.040,  0.000 > }
   object { thruster translate <  0.054, -0.040,  0.000 > }
   object { sr       translate <  0.000,  0.000,  0.000 > }
   object { solar    translate <  0.000,  0.040,  0.000 > }
   object { sr       translate <  0.000, -0.040,  0.000 > }
   object { sr       translate < -0.020, -0.020,  0.000 > }
   object { sr       translate < -0.020,  0.020,  0.000 > }
   object { sr       translate <  0.020, -0.020,  0.000 > }
   object { sr       translate <  0.020,  0.020,  0.000 > }
   object { sr       translate < -0.040,  0.000,  0.000 > }
   object { sr       translate <  0.040,  0.000,  0.000 > }
   object { solarh   translate < -0.020,  0.040,  0.000 > }
   object { solarh   translate <  0.020,  0.040,  0.000 > }
   object { shr      translate < -0.020, -0.060,  0.000 > }
   object { shr      translate <  0.020, -0.060,  0.000 > }
}

#ifndef ( nxyz ) 
   #declare nxyz=3;
#end

#declare ssxyz = union {
#declare of = 0.5*(1.0-nxyz);
#declare nz = 0 ;
#while( nz < nxyz )
   #declare dz = sp *( nz+of );
   #declare ny = 0 ;
   #while( ny < nxyz )
      #declare dy = sp *( ny+of );
      #declare nx = 0 ;
      #while( nx < nxyz )
         #declare dx = sp *( nx+of );
         object { ss1   translate < dx, dy, dz  > }
         #declare nx = nx + 1 ;
      #end
      #declare ny = ny + 1 ;
   #end
   #declare nz = nz + 1 ;
#end
}   // end of ssxyz

#declare ssxyzb = union {
#declare of = 0.5*(1.0-nxyz);
#declare nz = 0 ;
#while( nz < nxyz )
   #declare dz = sp *( nz+of );
   #declare ny = 0 ;
   #while( ny < nxyz )
      #declare dy = sp *( ny+of );
      #declare dx = sp * of ;
      object { ss1 translate < dx,dy,dz > }
      #declare nx = 1 ;
      #while( nx < nxyz )
         #declare dx = sp *( nx+of );
         object { ss1   translate < dx, dy, dz  > }
         object { xbeam translate < dx-sp,dy,dz > }
         object { ybeam translate < dy,dx-sp,dz > }
         object { zbeam translate < dy,dz,dx-sp > }
         #declare nx = nx + 1 ;
      #end
      #declare ny = ny + 1 ;
   #end
   #declare nz = nz + 1 ;
#end
}   // end of ssxyzb

