
#declare  M      =  1.0        ;    
#declare  KM     =  1000.0*M   ;
#declare  PI     =  3.14159265 ;
#declare  d2rad  =  PI/180.0   ;

// scale balls -------------------------------------------------------------

#declare scale0 = 0.000*M ;
#declare scale1 = 1.001*M ;
#declare scaleballs = union {
   #declare yb  =  scale0 ;
   #while ( yb <=  scale1 )
      sphere { yb*y, 0.030*M
         texture {
            pigment { color Blue   }
            finish  { ambient 1.0  }
         }
      }
      #declare yb = yb + 0.1*M ;
   #end
   #declare yb  =  scale0 ;
   #while ( yb <=  scale1 )
      sphere { yb*y, 0.040*M
         texture {
            pigment { color Green  }
            finish  { ambient 1.0  }
         }
      }
      #declare yb = yb + 0.5*M ;
   #end
   #declare yb  =  scale0 ;
   #while ( yb <=  scale1 )
      sphere { yb*y, 0.050*M
         texture {
            pigment { color Red    }
            finish  { ambient 1.0  }
         }
      }
      #declare yb = yb + 1.0*M ;
   #end
}

#declare cmscale0 = 0.0000*M ;
#declare cmscale1 = 0.1001*M ;
#declare cmlength = 0.0100*M ;
#declare cmlap    = 0.0001*M*z ;

#declare cmscale  = union {

   box { <-0.0007*M, 0.0, 0.0001>, < 0.0007*M, cmscale1, cmlength > 
      texture {
         pigment { color  rgb < 0.9, 0.9, 0.9 >  }
         finish  { ambient 1.0 diffuse 0.0  }
      }
   }

   #declare yb  =  cmscale0 ;
   #while ( yb <=  cmscale1 )
      cylinder { yb*y-2*cmlap,  yb*y+cmlength*z, 0.0012*M
         texture {
            pigment { color Blue   }
            finish  { ambient 1.0 diffuse 0.0  }
         }
      }
      #declare yb = yb + 0.10*M ;
   #end

   #declare yb  =  cmscale0 ;
   #while ( yb <=  cmscale1 )
      cylinder { yb*y-cmlap,  yb*y+cmlength*z, 0.0011*M
         texture {
            pigment { color Cyan  }
            finish  { ambient 1.0 diffuse 0.0  }
         }
      }
      #declare yb = yb + 0.05*M ;
   #end

   #declare yb  =  cmscale0 ;
   #while ( yb <=  cmscale1 )
      cylinder { yb*y,        yb*y+cmlength*z, 0.0010*M
         texture {
            pigment { color Magenta  }
            finish  { ambient 1.0 diffuse 0.0  }
         }
      }
      #declare yb = yb + 0.01*M ;
   #end
}

